import LocalizedStrings from 'localized-strings'
import env from '@/config/env.config'
import * as langHelper from '@/utils/langHelper'

const strings = new LocalizedStrings({
  fr: {
    NEW_CAR_HEADING: 'Nouvelle voiture',
    NAME: 'Nom',
    CAR_IMAGE_SIZE_ERROR: `L'image doit être au format ${env.CAR_IMAGE_WIDTH}x${env.CAR_IMAGE_HEIGHT}`,
    RECOMMENDED_IMAGE_SIZE: `Taille d'image recommandée : ${env.CAR_IMAGE_WIDTH}x${env.CAR_IMAGE_HEIGHT}`,
    SUPPLIER: 'Fournisseur',
    LOCATIONS: 'Lieux de prise en charge',
    AVAILABLE: 'Répertoriée dans les résultats de recherche',
    CAR_TYPE: 'Moteur',
    DAILY_PRICE: 'Prix/jour',
    DISCOUNTED_DAILY_PRICE: 'Prix discount/jour',
    HOURLY_PRICE: 'Prix/heure',
    DISCOUNTED_HOURLY_PRICE: 'Prix discount/heure',
    BI_WEEKLY_PRICE: 'Prix/mi-semaine (3 jours)',
    DISCOUNTED_BI_WEEKLY_PRICE: 'Prix discount/mi-semaine',
    WEEKLY_PRICE: 'Prix/semaine',
    DISCOUNTED_WEEKLY_PRICE: 'Prix discount/semaine',
    MONTHLY_PRICE: 'Prix/mois',
    DISCOUNTED_MONThLY_PRICE: 'Prix discount/mois',
    SEATS: 'Sièges',
    DOORS: 'Portes',
    GEARBOX: 'Transmission',
    AIRCON: 'Climatisation',
    MINIMUM_AGE: 'Âge minimum',
    MINIMUM_AGE_NOT_VALID: `L'âge minimum doit être supérieur ou égal à ${env.MINIMUM_AGE} ans.`,
    CAR_RANGE: 'Gamme',
    MULTIMEDIA: 'Multimédia',
    RATING: 'Notation',
    CO2: 'CO2 (g/km)',
    COMING_SOON: 'Bientôt Disponible',
    FULLY_BOOKED: 'Déjà réservée',
    IS_DATE_BASED_PRICE: 'Prix basé sur des dates',
    DATE_BASED_PRICES: 'Prix par dates',
    BLOCK_ON_PAY: 'Bloquer la voiture après un paiement réussi',
  },
  en: {
    NEW_CAR_HEADING: 'New car',
    NAME: 'Name',
    CAR_IMAGE_SIZE_ERROR: `The image must be in the format ${env.CAR_IMAGE_WIDTH}x${env.CAR_IMAGE_HEIGHT}`,
    RECOMMENDED_IMAGE_SIZE: `Recommended image size: ${env.CAR_IMAGE_WIDTH}x${env.CAR_IMAGE_HEIGHT}`,
    SUPPLIER: 'Supplier',
    LOCATIONS: 'Pick-up locations',
    AVAILABLE: 'Listed in search results',
    CAR_TYPE: 'Engine',
    DAILY_PRICE: 'Daily Price',
    DISCOUNTED_DAILY_PRICE: 'Discounted Daily Price',
    HOURLY_PRICE: 'Hourly Price (1h)',
    DISCOUNTED_HOURLY_PRICE: 'Discounted Hourly Price (1h)',
    BI_WEEKLY_PRICE: 'Bi-Weekly Price (3 days)',
    DISCOUNTED_BI_WEEKLY_PRICE: 'Discounted Bi-Weekly Price',
    WEEKLY_PRICE: 'Weekly Price',
    DISCOUNTED_WEEKLY_PRICE: 'Discounted Weekly Price',
    MONTHLY_PRICE: 'Monthly Price',
    DISCOUNTED_MONThLY_PRICE: 'Discounted Monthly Price',
    SEATS: 'Seats',
    DOORS: 'Doors',
    GEARBOX: 'Gearbox',
    AIRCON: 'Aircon',
    MINIMUM_AGE: 'Minimum age',
    MINIMUM_AGE_NOT_VALID: `Minimum age must be greater than or equal to ${env.MINIMUM_AGE} years old.`,
    CAR_RANGE: 'Car Range',
    MULTIMEDIA: 'Multimedia',
    RATING: 'Rating',
    CO2: 'CO2 (g/km)',
    COMING_SOON: 'Coming Soon',
    FULLY_BOOKED: 'Fully Booked',
    IS_DATE_BASED_PRICE: 'Date Based Prices',
    DATE_BASED_PRICES: 'Date Based Prices',
    BLOCK_ON_PAY: 'Block Car On Successful Payment',
  },
  es: {
    NEW_CAR_HEADING: 'Nuevo coche',
    NAME: 'Nombre',
    CAR_IMAGE_SIZE_ERROR: `La imagen debe tener el formato ${env.CAR_IMAGE_WIDTH}x${env.CAR_IMAGE_HEIGHT}`,
    RECOMMENDED_IMAGE_SIZE: `Tamaño de imagen recomendado: ${env.CAR_IMAGE_WIDTH}x${env.CAR_IMAGE_HEIGHT}`,
    SUPPLIER: 'Proveedor',
    LOCATIONS: 'Lugares de recogida',
    AVAILABLE: 'Incluido en los resultados de búsqueda',
    CAR_TYPE: 'Motor',
    DAILY_PRICE: 'Precio diario',
    DISCOUNTED_DAILY_PRICE: 'Precio diario con descuento',
    HOURLY_PRICE: 'Precio por hora (1h)',
    DISCOUNTED_HOURLY_PRICE: 'Precio por hora con descuento (1h)',
    BI_WEEKLY_PRICE: 'Precio quincenal (3 días)',
    DISCOUNTED_BI_WEEKLY_PRICE: 'Precio quincenal con descuento',
    WEEKLY_PRICE: 'Precio semanal',
    DISCOUNTED_WEEKLY_PRICE: 'Precio semanal con descuento',
    MONTHLY_PRICE: 'Precio mensual',
    DISCOUNTED_MONThLY_PRICE: 'Precio mensual con descuento',
    SEATS: 'Asientos',
    DOORS: 'Puertas',
    GEARBOX: 'Caja de cambios',
    AIRCON: 'Aire acondicionado',
    MINIMUM_AGE: 'Edad mínima',
    MINIMUM_AGE_NOT_VALID: `La edad mínima debe ser mayor o igual a ${env.MINIMUM_AGE} años.`,
    CAR_RANGE: 'Gama',
    MULTIMEDIA: 'Multimedia',
    RATING: 'Calificación',
    CO2: 'CO2 (g/km)',
    COMING_SOON: 'Próximamente',
    FULLY_BOOKED: 'Ya Reservado',
    IS_DATE_BASED_PRICE: 'Precio basado en fechas',
    DATE_BASED_PRICES: 'Precios por fechas',
    BLOCK_ON_PAY: 'Bloquear el coche tras el pago exitoso',

  },
})

langHelper.setLanguage(strings)
export { strings }
